package cn.iocoder.foodnexus.module.order.controller.app.shoppingcart.vo;

import lombok.*;
import java.util.*;
import io.swagger.v3.oas.annotations.media.Schema;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;

import static cn.iocoder.foodnexus.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 购物车分页 Request VO")
@Data
public class ShoppingCartPageReqVO extends PageParam {

    @Schema(description = "商品id", example = "7172")
    private Long productId;

    @Schema(description = "商品名称", example = "王五")
    private String productName;

    @Schema(description = "单价(分)", example = "6013")
    private Integer unitPrice;

    @Schema(description = "下单数量")
    private Integer orderQuantity;

    @Schema(description = "备注", example = "随便")
    private String remark;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;

    @Schema(hidden = true)
    private Long creator;

}