package cn.iocoder.foodnexus.module.operations.service.customerrequire;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import jakarta.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.*;
import cn.iocoder.foodnexus.module.operations.controller.admin.customerrequire.vo.*;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.customerrequire.CustomerRequireDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import cn.iocoder.foodnexus.framework.common.util.object.BeanUtils;

import cn.iocoder.foodnexus.module.operations.dal.mysql.customerrequire.CustomerRequireMapper;

import static cn.iocoder.foodnexus.framework.common.exception.util.ServiceExceptionUtil.exception;
import static cn.iocoder.foodnexus.framework.common.util.collection.CollectionUtils.convertList;
import static cn.iocoder.foodnexus.framework.common.util.collection.CollectionUtils.diffList;
import static cn.iocoder.foodnexus.module.operations.enums.ErrorCodeConstants.*;

/**
 * 客户需求 Service 实现类
 *
 * @author 超级管理员
 */
@Service
@Validated
public class CustomerRequireServiceImpl implements CustomerRequireService {

    @Resource
    private CustomerRequireMapper customerRequireMapper;

    @Override
    public Long createCustomerRequire(CustomerRequireSaveReqVO createReqVO) {
        // 插入
        CustomerRequireDO customerRequire = BeanUtils.toBean(createReqVO, CustomerRequireDO.class);
        customerRequireMapper.insert(customerRequire);

        // 返回
        return customerRequire.getId();
    }

    @Override
    public void updateCustomerRequire(CustomerRequireSaveReqVO updateReqVO) {
        // 校验存在
        validateCustomerRequireExists(updateReqVO.getId());
        // 更新
        CustomerRequireDO updateObj = BeanUtils.toBean(updateReqVO, CustomerRequireDO.class);
        customerRequireMapper.updateById(updateObj);
    }

    @Override
    public void deleteCustomerRequire(Long id) {
        // 校验存在
        validateCustomerRequireExists(id);
        // 删除
        customerRequireMapper.deleteById(id);
    }

    @Override
        public void deleteCustomerRequireListByIds(List<Long> ids) {
        // 删除
        customerRequireMapper.deleteByIds(ids);
        }


    private void validateCustomerRequireExists(Long id) {
        CustomerRequireDO customerRequireDO = customerRequireMapper.selectById(id);
        if (customerRequireDO == null) {
            throw exception(CUSTOMER_REQUIRE_NOT_EXISTS);
        }
        if (customerRequireDO.getIsRequire()) {
            throw exception(CUSTOMER_REQUIRE_IS_REQUIRE);
        }
    }

    @Override
    public CustomerRequireDO getCustomerRequire(Long id) {
        return customerRequireMapper.selectById(id);
    }

    @Override
    public PageResult<CustomerRequireDO> getCustomerRequirePage(CustomerRequirePageReqVO pageReqVO) {
        return customerRequireMapper.selectPage(pageReqVO);
    }

    @Override
    public void require(Long id) {
        this.validateCustomerRequireExists(id);
        customerRequireMapper.update(Wrappers.<CustomerRequireDO>lambdaUpdate()
                .set(CustomerRequireDO::getIsRequire, Boolean.TRUE)
                .set(CustomerRequireDO::getRequireTime, LocalDateTime.now())
                .eq(CustomerRequireDO::getId, id));
    }

}