package cn.iocoder.foodnexus.module.erp.controller.admin.purchase.vo.returns;

import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import cn.iocoder.foodnexus.framework.common.validation.InEnum;
import cn.iocoder.foodnexus.module.erp.api.enums.ErpDeliveryStatus;
import cn.iocoder.foodnexus.module.erp.enums.SaleOrderPickUpStatus;
import cn.iocoder.foodnexus.module.order.enums.DeliveryMode;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.List;

import static cn.iocoder.foodnexus.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - ERP 采购退货分页 Request VO")
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ErpPurchaseReturnPageReqVO extends PageParam {

    public static final Integer REFUND_STATUS_NONE = 0;
    public static final Integer REFUND_STATUS_PART = 1;
    public static final Integer REFUND_STATUS_ALL = 2;

    @Schema(description = "采购单编号", example = "XS001")
    private String no;

    @Schema(description = "供应商编号", example = "1724")
    private Long supplierId;

    @Schema(description = "退货时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] returnTime;

    @Schema(description = "备注", example = "你猜")
    private String remark;

    @Schema(description = "退货状态", example = "2")
    private Integer status;

    @Schema(description = "创建者")
    private String creator;

    @Schema(description = "产品编号", example = "1")
    private Long productId;

    @Schema(description = "仓库编号", example = "1")
    private Long warehouseId;

    @Schema(description = "结算账号编号", example = "1")
    private Long accountId;

    @Schema(description = "采购单号", example = "1")
    private String orderNo;

    @Schema(description = "退款状态", example = "1")
    private Integer refundStatus;

    @Schema(description = "是否可退款", example = "true")
    private Boolean refundEnable; // 对应 refundStatus = [0, 1]

    /**
     * 枚举 {@link SaleOrderPickUpStatus}
     */
    @Schema(description = "退货状态")
    @InEnum(SaleOrderPickUpStatus.class)
    private String returnsStatus;

    @Schema(description = "客户订单id")
    private Long customerOrderId;

    @Schema(description = "客户名称")
    private String customerName;

    @Schema(description = "联系人")
    private String contactUser;

    @Schema(description = "联系号码")
    private String contactPhone;

    @Schema(description = "商品名称")
    private String productName;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;

    @Schema(description = "配送时间")
    private LocalDateTime[] deliveryTime;

}