package cn.iocoder.foodnexus.framework.common.enums;

import cn.iocoder.foodnexus.framework.common.core.ArrayValuable;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

/**
 * @author : yanghao
 * create at:  2025/10/29  09:52
 * @description: 客户类型
 */
@Getter
@AllArgsConstructor
public enum CustomerTypeEnum implements ArrayValuable<Integer> {

    CUSTOMER(0, "客户"),

    CHIEF(1, "司务长"),

    ;

    private final Integer key;
    private final String value;


    public static final Integer[] ARRAYS = Arrays.stream(values()).map(CustomerTypeEnum::getKey).toArray(Integer[]::new);
    /**
     * @return 数组
     */
    @Override
    public Integer[] array() {
        return ARRAYS;
    }
}
