package cn.iocoder.foodnexus.module.product.controller.app.spu.vo;

import cn.iocoder.foodnexus.module.product.controller.app.property.vo.value.AppProductPropertyValueDetailRespVO;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Schema(description = "用户 App - 商品 SPU 明细 Response VO")
@Data
public class AppProductSpuDetailRespVO {

    @Schema(description = "商品 SPU 编号", requiredMode = Schema.RequiredMode.REQUIRED, example = "1")
    private Long id;

    // ========== 基本信息 =========

    @Schema(description = "商品名称", requiredMode = Schema.RequiredMode.REQUIRED, example = "芋道")
    private String name;

    @Schema(description = "商品规格", requiredMode = Schema.RequiredMode.REQUIRED, example = "我是一个快乐简介")
    private String introduction;

    @Schema(description = "商品详情", requiredMode = Schema.RequiredMode.REQUIRED, example = "我是商品描述")
    private String description;

    @Schema(description = "商品分类编号", requiredMode = Schema.RequiredMode.REQUIRED, example = "1")
    private Long categoryId;

    @Schema(description = "商品封面图", requiredMode = Schema.RequiredMode.REQUIRED)
    private String picUrl;

    @Schema(description = "商品轮播图", requiredMode = Schema.RequiredMode.REQUIRED)
    private List<String> sliderPicUrls;

    @Schema(description = "供应商报价")
    private Integer supplierQuote;

    @Schema(description = "商品单位")
    private String unitName;

    @Schema(description = "市场价")
    private Integer marketPrice;

    @Schema(description = "下浮率(%)")
    private BigDecimal discount;


}
