package cn.iocoder.foodnexus.module.order.service.customerorder;

import java.util.*;

import cn.iocoder.foodnexus.module.order.controller.app.customerOrder.vo.*;
import cn.iocoder.foodnexus.module.order.controller.app.customerOrder.vo.AppCustomerOrderSaveReqVO;
import cn.iocoder.foodnexus.module.order.dto.AppCustomerReturnOrderReqVO;
import jakarta.validation.*;
import cn.iocoder.foodnexus.module.order.controller.admin.customerorder.vo.*;
import cn.iocoder.foodnexus.module.order.dal.dataobject.customerorder.CustomerOrderDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;

/**
 * 客户总订单 Service 接口
 *
 * @author 超级管理员
 */
public interface CustomerOrderService {

    /**
     * 创建客户总订单
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createCustomerOrder(@Valid CustomerOrderSaveReqVO createReqVO);

    /**
     * 更新客户总订单
     *
     * @param updateReqVO 更新信息
     */
    void updateCustomerOrder(@Valid CustomerOrderSaveReqVO updateReqVO);

    /**
     * 删除客户总订单
     *
     * @param id 编号
     */
    void deleteCustomerOrder(Long id);

    /**
    * 批量删除客户总订单
    *
    * @param ids 编号
    */
    void deleteCustomerOrderListByIds(List<Long> ids);

    /**
     * 获得客户总订单
     *
     * @param id 编号
     * @return 客户总订单
     */
    CustomerOrderDO getCustomerOrder(Long id);

    /**
     * 获得客户总订单分页
     *
     * @param pageReqVO 分页查询
     * @return 客户总订单分页
     */
    PageResult<CustomerOrderDO> getCustomerOrderPage(CustomerOrderPageReqVO pageReqVO);

    /**
     * 客户创建订单
     * @param createReqVO
     * @return
     */
    Long appCreateCustomerOrder(AppCustomerOrderSaveReqVO createReqVO);

    /**
     * 客户修改订单
     * @param updateReqVO
     */
    void appUpdateCustomerOrder(AppCustomerOrderSaveReqVO updateReqVO);

    /**
     * 取消订单
     * @param id
     */
    void cancel(AppCustomerOrderRemarkReqVO reqVO);

    /**
     * 签收订单
     * @param reqVO
     */
    void receipt(AppCustomerOrderRemarkReqVO reqVO);

    /**
     * 签收前查询相关信息（销售出库单）
     * @param id
     * @return
     */
    List<AppCustomerOrderReceiptRespVO> queryReceipt(Long id);

    /**
     * 订单退货
     * @param reqVO
     */
    void orderReturn(AppCustomerReturnOrderReqVO reqVO);

    /**
     * 查询订单评价
     * @param id
     * @return
     */
    AppCustomerOrderScoreRespVO queryScore(Long id);

    /**
     * 评价订单
     * @param reqVO
     */
    void score(AppCustomerOrderScoreReqVO reqVO);

    Map<String, Long> queryStatusCount(Long loginUserId);

    /**
     * 分页获取月度账单
     * @param reqVO
     * @return
     */
    AppCustomerMonthOrderRespVO reconciliationPageYear(AppCustomerYearOrderPageReqVO reqVO);

    /**
     * 月订单汇总
     * @param yearMonth
     * @return
     */
    AppCustomerMonthOrderTotalRespVO monthTotal(String yearMonth);

    /**
     * 对账确认
     * @param reqVO
     */
    void reconciliationConfirm(AppCustomerOrderReconciliationReqVO reqVO);

    /**
     * 查询退款
     * @param id
     * @return
     */
    AppCustomerOrderReturnRespVO queryReturn(Long id);
}