package cn.iocoder.foodnexus.module.order.dal.mysql.orderScore;

import java.util.*;

import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.foodnexus.module.order.dal.dataobject.orderScore.OrderScoreDO;
import org.apache.ibatis.annotations.Mapper;
import cn.iocoder.foodnexus.module.order.controller.admin.orderScore.vo.*;

/**
 * 订单评价 Mapper
 *
 * @author 超级管理员
 */
@Mapper
public interface OrderScoreMapper extends BaseMapperX<OrderScoreDO> {

    default PageResult<OrderScoreDO> selectPage(OrderScorePageReqVO reqVO) {
        return selectPage(reqVO, new LambdaQueryWrapperX<OrderScoreDO>()
                .eqIfPresent(OrderScoreDO::getOrderId, reqVO.getOrderId())
                .eqIfPresent(OrderScoreDO::getScoreId, reqVO.getScoreId())
                .likeIfPresent(OrderScoreDO::getScoreName, reqVO.getScoreName())
                //.eqIfPresent(OrderScoreDO::getSupplierId, reqVO.getSupplierId())
                .eqIfPresent(OrderScoreDO::getCustomerId, reqVO.getCustomerId())
                .eqIfPresent(OrderScoreDO::getScore, reqVO.getScore())
                .betweenIfPresent(OrderScoreDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(OrderScoreDO::getId));
    }

}