package cn.iocoder.foodnexus.module.order.dal.dataobject.checktask;

import cn.iocoder.foodnexus.module.order.enums.CheckTaskStatus;
import lombok.*;
import java.util.*;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;

/**
 * 来料质检 DO
 *
 * @author 超级管理员
 */
@TableName("order_check_task")
@KeySequence("order_check_task_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CheckTaskDO extends BaseDO {

    /**
     * id
     */
    @TableId
    private Long id;
    /**
     * 编号
     */
    private String no;
    /**
     * 状态
     *
     * 枚举 {@link CheckTaskStatus}
     */
    private String status;
    /**
     * 供应商编号
     */
    private Long supplierId;
    /**
     * 关联采购订单id
     */
    private Long purchaseOrderId;
    /**
     * 关联客户订单id
     */
    private Long customerOrderId;
    /**
     * 客户id
     */
    private Long customerId;
    /**
     * 到货时间
     */
    private LocalDateTime arrivalTime;
    /**
     * 备注
     */
    private String remark;
    /**
     * 附件
     */
    private String files;
    /**
     * 质检时间
     */
    private LocalDateTime checkTime;
    /**
     * 质检用户
     */
    private Long checkUserId;
    /**
     * 供应商评价
     */
    private String scoreRemark;

}