package cn.iocoder.foodnexus.module.order.controller.app.customerOrder.vo;

import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author : yanghao
 * create at:  2025/10/13  14:19
 * @description: APP - 用户订单按月汇总
 */
@Data
public class AppCustomerMonthOrderRespVO {

    @Schema(description = "订单总数")
    private Long orderCount;

    @Schema(description = "订单总金额")
    private BigDecimal orderAmount;

    @Schema(description = "月份对账信息分页")
    private PageResult<MonthItems> pageResult;

    @Data
    public static class MonthItems {

        @Schema(description = "月份(yyyy年xx月)")
        private String yearMonth;

        @Schema(description = "订单总数")
        private Long orderCount;

        @Schema(description = "总金额（分）")
        private BigDecimal orderAmount;

        @Schema(description = "应对账总金额(分)")
        private BigDecimal payableAmount;

        @Schema(description = "状态(是否对账)")
        private Boolean status;

    }

}
