package cn.iocoder.foodnexus.module.order.controller.admin.orderScore.vo;

import cn.iocoder.foodnexus.module.erp.controller.admin.purchase.vo.supplier.ErpSupplierRespVO;
import cn.iocoder.foodnexus.module.erp.controller.admin.purchase.vo.supplier.ErpSupplierSimpleRespVO;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author : yanghao
 * create at:  2025/10/13  18:14
 * @description: 供应商 - 评价
 */
@Data
public class OrderScoreSupplierRespVO {

    @Schema(description = "评分年度")
    private String year;

    @Schema(description = "供应商id")
    private Long supplierId;

    @Schema(description = "供应商信息")
    private ErpSupplierSimpleRespVO supplierInfo;

    @Schema(description = "评分维度得分")
    private List<ScoreItems> scoreItems;

    @Schema(description = "综合得分")
    private BigDecimal finalScore;


    @Data
    public static class ScoreItems {

        @Schema(description = "评价指标id")
        private Long scoreId;

        @Schema(description = "评价指标名称")
        private String scoreName;

        @Schema(description = "总得分")
        private Integer allScore;

        @Schema(description = "总评价数")
        private Integer scoreCount;

        @Schema(description = "得分(平均)")
        private BigDecimal score;

    }

}
