package cn.iocoder.foodnexus.module.order.controller.admin.orderScore.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import jakarta.validation.constraints.*;

@Schema(description = "管理后台 - 订单评价新增/修改 Request VO")
@Data
public class OrderScoreSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "12656")
    private Long id;

    @Schema(description = "客户订单id", requiredMode = Schema.RequiredMode.REQUIRED, example = "4107")
    @NotNull(message = "客户订单id不能为空")
    private Long orderId;

    @Schema(description = "评价指标id", requiredMode = Schema.RequiredMode.REQUIRED, example = "15052")
    @NotNull(message = "评价指标id不能为空")
    private Long scoreId;

    @Schema(description = "评价指标名称", example = "芋艿")
    private String scoreName;

    @Schema(description = "供应商id", requiredMode = Schema.RequiredMode.REQUIRED, example = "23453")
    @NotNull(message = "供应商id不能为空")
    private Long supplierId;

    @Schema(description = "客户id", requiredMode = Schema.RequiredMode.REQUIRED, example = "7606")
    @NotNull(message = "客户id不能为空")
    private Long customerId;

    @Schema(description = "得分", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotNull(message = "得分不能为空")
    private Integer score;

    @Schema(description = "排序")
    private Integer sort;

}