package cn.iocoder.foodnexus.module.order.controller.admin.customerorderitem.vo;

import cn.iocoder.foodnexus.module.product.api.dto.ProductInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import jakarta.validation.constraints.*;

@Schema(description = "管理后台 - 客户订单-子订单新增/修改 Request VO")
@Data
public class CustomerOrderItemSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "22980")
    private Long id;

    @Schema(description = "客户订单id", requiredMode = Schema.RequiredMode.REQUIRED, example = "15521")
    @NotNull(message = "客户订单id不能为空")
    private Long orderId;

    @Schema(description = "客户id", requiredMode = Schema.RequiredMode.REQUIRED, example = "18288")
    @NotNull(message = "客户id不能为空")
    private Long customerId;

    @Schema(description = "商品id", requiredMode = Schema.RequiredMode.REQUIRED, example = "9665")
    @NotNull(message = "商品id不能为空")
    private Long productId;

    @Schema(description = "商品名称", example = "李四")
    private String productName;

    @Schema(description = "商品信息")
    private ProductInfo productInfo;

    @Schema(description = "商品对应供应商id", requiredMode = Schema.RequiredMode.REQUIRED, example = "19874")
    @NotNull(message = "商品对应供应商id不能为空")
    private Long supplierId;

    @Schema(description = "供应商名称", example = "芋艿")
    private String supplierName;

    @Schema(description = "订单商品单价，单位：分", requiredMode = Schema.RequiredMode.REQUIRED, example = "29922")
    @NotNull(message = "订单商品单价，单位：分不能为空")
    private Integer orderItemPrice;

    @Schema(description = "订单商品总价，单位：分", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotNull(message = "订单商品总价，单位：分不能为空")
    private Integer orderItemTotal;

    @Schema(description = "订单商品数量", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotNull(message = "订单商品数量不能为空")
    private Integer orderItemQuantity;

    @Schema(description = "签收数量", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotNull(message = "签收数量不能为空")
    private Integer signedQuantity;

    @Schema(description = "签收总价，单位：分", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotNull(message = "签收总价，单位：分不能为空")
    private Integer signedTotal;

}