package cn.iocoder.foodnexus.module.order.controller.admin.checktask.vo;

import lombok.*;
import java.util.*;
import io.swagger.v3.oas.annotations.media.Schema;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;

import static cn.iocoder.foodnexus.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 来料质检分页 Request VO")
@Data
public class CheckTaskPageReqVO extends PageParam {

    @Schema(description = "编号")
    private String no;

    @Schema(description = "状态", example = "2")
    private String status;

    @Schema(description = "供应商编号", example = "10284")
    private Long supplierId;

    @Schema(description = "关联采购订单id", example = "31869")
    private Long purchaseOrderId;

    @Schema(description = "关联客户订单id", example = "1535")
    private Long customerOrderId;

    @Schema(description = "客户id", example = "7050")
    private Long customerId;

    @Schema(description = "到货时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] arrivalTime;

    @Schema(description = "备注", example = "你猜")
    private String remark;

    @Schema(description = "附件")
    private String files;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;

}