package cn.iocoder.foodnexus.module.operations.service.scoringweight;

import java.util.*;

import cn.iocoder.foodnexus.framework.common.enums.UserSystemEnum;
import jakarta.validation.*;
import cn.iocoder.foodnexus.module.operations.controller.admin.scoringweight.vo.*;
import cn.iocoder.foodnexus.module.operations.dal.dataobject.scoringweight.ScoringWeightDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;

/**
 * 评分权重 Service 接口
 *
 * @author 超级管理员
 */
public interface ScoringWeightService {

    /**
     * 创建评分权重
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createScoringWeight(@Valid ScoringWeightSaveReqVO createReqVO);

    /**
     * 更新评分权重
     *
     * @param updateReqVO 更新信息
     */
    void updateScoringWeight(@Valid ScoringWeightUpateReqVO updateReqVO);

    /**
     * 删除评分权重
     *
     * @param id 编号
     */
    void deleteScoringWeight(Long id);

    /**
    * 批量删除评分权重
    *
    * @param ids 编号
    */
    void deleteScoringWeightListByIds(List<Long> ids);

    /**
     * 获得评分权重
     *
     * @param id 编号
     * @return 评分权重
     */
    ScoringWeightDO getScoringWeight(Long id);

    /**
     * 获得评分权重分页
     *
     * @param pageReqVO 分页查询
     * @return 评分权重分页
     */
    PageResult<ScoringWeightDO> getScoringWeightPage(ScoringWeightPageReqVO pageReqVO);

    List<ScoringWeightDO> queryByUserSystem(UserSystemEnum userSystemEnum);

    /**
     * 设置权重
     * @param reqVO
     */
    void edit(ScoringWeightEditReqVO reqVO);

    List<ScoringWeightDO> listAll();
}