package cn.iocoder.foodnexus.module.operations.controller.admin.scoringweight.vo;

import lombok.*;
import java.util.*;
import io.swagger.v3.oas.annotations.media.Schema;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import java.math.BigDecimal;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;

import static cn.iocoder.foodnexus.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 评分权重分页 Request VO")
@Data
public class ScoringWeightPageReqVO extends PageParam {

    @Schema(description = "评价指标名称", example = "赵六")
    private String scoreName;

    @Schema(description = "评分权重")
    private BigDecimal weightRatio;

    @Schema(description = "是否展示")
    private Boolean isDisplay;

    @Schema(description = "面向用户群体")
    private String userSystem;

    @Schema(description = "排序")
    private Integer sort;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;

}