package cn.iocoder.foodnexus.module.operations.controller.admin.scoringweight.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author : yanghao
 * create at:  2025/10/13  17:32
 * @description:
 */
@Data
public class ScoringWeightEditReqVO {

    @Schema(description = "设置权重项")
    @NotNull(message = "设置权重项不能为空")
    @Size(min = 1, message = "设置权重项不能为空")
    @Valid
    private List<EditItems> editItems;

    @Data
    public static class EditItems {

        @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "8877")
        @NotNull(message = "id不能为空")
        private Long id;

        @Schema(description = "评分权重,单位：%", requiredMode = Schema.RequiredMode.REQUIRED)
        @NotNull(message = "评分权重不能为空")
        private BigDecimal weightRatio;

    }

}
