package cn.iocoder.foodnexus.module.operations.controller.admin.inquiresupplierpush.vo;

import cn.iocoder.foodnexus.module.operations.controller.admin.inquirepriceitem.vo.InquirePriceItemRespVO;
import cn.iocoder.foodnexus.module.product.controller.admin.spu.vo.ProductSpuRespVO;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import cn.idev.excel.annotation.*;

@Schema(description = "管理后台 - 询价推送 Response VO")
@Data
@ExcelIgnoreUnannotated
public class InquireSupplierPushRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "30131")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "供应商id", requiredMode = Schema.RequiredMode.REQUIRED, example = "17271")
    @ExcelProperty("供应商id")
    private Long supplierId;

    @Schema(description = "供应商name")
    private String supplierName;

    @Schema(description = "询价主题id", requiredMode = Schema.RequiredMode.REQUIRED, example = "20378")
    @ExcelProperty("询价主题id")
    private Long inquirePriceId;

    @Schema(description = "询价子id")
    private Long inquirePriceItemId;

    @Schema(description = "询价子项")
    private InquirePriceItemRespVO inquirePriceItem;

    @Schema(description = "商品id", requiredMode = Schema.RequiredMode.REQUIRED, example = "3596")
    @ExcelProperty("商品id")
    private Long productId;

    @Schema(description = "商品spu")
    private ProductSpuRespVO productSpu;

    @Schema(description = "商品分类id", requiredMode = Schema.RequiredMode.REQUIRED, example = "2949")
    @ExcelProperty("商品分类id")
    private Long categoryId;

    @Schema(description = "供应商报价")
    @ExcelProperty("供应商报价")
    private Integer supplierQuote;

    @Schema(description = "是否确认", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("是否确认")
    private Boolean confirm;

    @Schema(description = "确认人员")
    @ExcelProperty("确认人员")
    private Long confirmUser;

    @Schema(description = "确认时间")
    @ExcelProperty("确认时间")
    private LocalDateTime confirmTime;

    @Schema(description = "创建时间")
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

}