package cn.iocoder.foodnexus.module.operations.controller.admin.inquirepriceitem.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import jakarta.validation.constraints.*;
import java.math.BigDecimal;

@Schema(description = "管理后台 - 询价管理子新增/修改 Request VO")
@Data
public class InquirePriceItemSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "7765")
    private Long id;

    @Schema(description = "询价id", requiredMode = Schema.RequiredMode.REQUIRED, example = "7342")
    // @NotNull(message = "询价id不能为空")
    private Long inquireId;

    @Schema(description = "商品id", requiredMode = Schema.RequiredMode.REQUIRED, example = "10941")
    @NotNull(message = "商品id不能为空")
    private Long productId;

    @Schema(description = "商品分类编号", requiredMode = Schema.RequiredMode.REQUIRED, example = "13698")
    @NotNull(message = "商品分类编号不能为空")
    private Long categoryId;

    @Schema(description = "分类名称", example = "李四")
    private String categoryName;


    @Schema(description = "商品规格")
    private String productStandard;

    @Schema(description = "商品单位")
    private String productUnit;

    @Schema(description = "市场价，单位使用：分", example = "22500")
    private Integer marketPrice;

    @Schema(description = "下浮率(%)")
    private BigDecimal floatingRate;

    @Schema(description = "下浮后价格（分）", example = "2164")
    private Integer floatingPrice;

}