package cn.iocoder.foodnexus.module.operations.controller.admin.deliverystaff.vo;

import cn.iocoder.foodnexus.module.erp.controller.admin.sale.vo.customer.ErpCustomerRespVO;
import cn.iocoder.foodnexus.module.operations.controller.admin.vehicleinfo.vo.VehicleInfoRespVO;
import cn.iocoder.foodnexus.module.system.controller.admin.dept.vo.dept.DeptSimpleRespVO;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import cn.idev.excel.annotation.*;
import cn.iocoder.foodnexus.framework.excel.core.annotations.DictFormat;
import cn.iocoder.foodnexus.framework.excel.core.convert.DictConvert;

@Schema(description = "管理后台 - 配送员信息 Response VO")
@Data
@ExcelIgnoreUnannotated
public class DeliveryStaffRespVO {

    @Schema(description = "主键ID", requiredMode = Schema.RequiredMode.REQUIRED, example = "15492")
    @ExcelProperty("主键ID")
    private Long id;

    @Schema(description = "姓名", requiredMode = Schema.RequiredMode.REQUIRED, example = "芋艿")
    @ExcelProperty("姓名")
    private String name;

    @Schema(description = "身份证号", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("身份证号")
    private String idNumber;

    @Schema(description = "联系方式")
    @ExcelProperty("联系方式")
    private String contact;

    @Schema(description = "在岗状态", example = "1")
    @ExcelProperty(value = "在岗状态", converter = DictConvert.class)
    @DictFormat("oper_on_duty_status") // TODO 代码优化：建议设置到对应的 DictTypeConstants 枚举类中
    private String onDutyStatus;

    @Schema(description = "人员出生年份")
    @ExcelProperty("人员出生年份")
    private Integer staffYearBirth;

    @Schema(description = "健康状态", example = "1")
    @ExcelProperty(value = "健康状态", converter = DictConvert.class)
    @DictFormat("oper_health_status") // TODO 代码优化：建议设置到对应的 DictTypeConstants 枚举类中
    private String healthStatus;

    @Schema(description = "驾驶证类型", example = "1")
    @ExcelProperty("驾驶证类型")
    private String driverLicenseType;

    @Schema(description = "驾驶证有效期开始时间")
    @ExcelProperty("驾驶证有效期开始时间")
    private LocalDateTime licenseStartTime;

    @Schema(description = "驾驶证有效期结束时间")
    @ExcelProperty("驾驶证有效期结束时间")
    private LocalDateTime licenseEndTime;

    @Schema(description = "驾驶证状态", example = "1")
    @ExcelProperty(value = "驾驶证状态", converter = DictConvert.class)
    @DictFormat("oper_normal_status") // TODO 代码优化：建议设置到对应的 DictTypeConstants 枚举类中
    private String driverLicenseStatus;

    @Schema(description = "健康证明文件路径")
    @ExcelProperty("健康证明文件路径")
    private String healthCertificateFile;

    @Schema(description = "机动车驾驶证图片路径")
    @ExcelProperty("机动车驾驶证图片路径")
    private String driverLicenseFile;

    @Schema(description = "备注", example = "你猜")
    @ExcelProperty("备注")
    private String remark;

    @Schema(description = "创建时间")
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;


    @Schema(description = "绑定车辆信息")
    private VehicleInfoRespVO vehicleInfo;

    @Schema(description = "绑定客户信息")
    private List<ErpCustomerRespVO> customerList;

    @Schema(description = "绑定灶点信息")
    private List<DeptSimpleRespVO> customerDeptList;

}