package cn.iocoder.foodnexus.module.operations.controller.admin.customerrequire.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import cn.idev.excel.annotation.*;

@Schema(description = "管理后台 - 客户需求 Response VO")
@Data
@ExcelIgnoreUnannotated
public class CustomerRequireRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "32398")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "客户id", requiredMode = Schema.RequiredMode.REQUIRED, example = "23236")
    @ExcelProperty("客户id")
    private Long customerId;

    @Schema(description = "需求标题", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("需求标题")
    private String requireTitle;

    @Schema(description = "需求内容")
    @ExcelProperty("需求内容")
    private String requireContent;

    @Schema(description = "商品分类编号", example = "28601")
    @ExcelProperty("商品分类编号")
    private Long categoryId;

    @Schema(description = "是否受理", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("是否受理")
    private Boolean isRequire;

    @Schema(description = "受理时间")
    private LocalDateTime requireTime;

    @Schema(description = "创建时间")
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

    @Schema(description = "更新时间")
    @ExcelProperty("更新时间")
    private LocalDateTime updateTime;

    @Schema(description = "创建人")
    @ExcelProperty("创建人")
    private String creator;

}