package cn.iocoder.foodnexus.module.erp.controller.admin.product.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import cn.idev.excel.annotation.*;

@Schema(description = "管理后台 - 供应商关联商品 Response VO")
@Data
@ExcelIgnoreUnannotated
public class ProductSupplierRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "23757")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "商品id", requiredMode = Schema.RequiredMode.REQUIRED, example = "19411")
    @ExcelProperty("商品id")
    private Long productId;

    @Schema(description = "供应商id", requiredMode = Schema.RequiredMode.REQUIRED, example = "3025")
    @ExcelProperty("供应商id")
    private Long supplierId;

    @Schema(description = "创建时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

}