package cn.iocoder.foodnexus.module.order.dal.dataobject.customerorderitem;

import cn.iocoder.foodnexus.module.order.dto.CustomerOrderRemark;
import cn.iocoder.foodnexus.module.product.api.dto.ProductInfo;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import lombok.*;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;

/**
 * 客户订单-子订单 DO
 *
 * @author 超级管理员
 */
@TableName(value = "order_customer_order_item", autoResultMap = true)
@KeySequence("order_customer_order_item_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CustomerOrderItemDO extends BaseDO {

    /**
     * id
     */
    @TableId
    private Long id;
    /**
     * 客户订单id
     */
    private Long orderId;
    /**
     * 客户id
     */
    private Long customerId;
    /**
     * 商品id
     */
    private Long productId;
    /**
     * 商品名称
     */
    private String productName;
    /**
     * 商品信息
     */
    @TableField(typeHandler = JacksonTypeHandler.class)
    private ProductInfo productInfo;
    /**
     * 商品对应供应商id
     */
    private Long supplierId;
    /**
     * 供应商名称
     */
    private String supplierName;
    /**
     * 订单商品单价，单位：分
     */
    private Integer orderItemPrice;
    /**
     * 订单商品总价，单位：分
     */
    private Integer orderItemTotal;
    /**
     * 订单商品数量
     */
    private Integer orderItemQuantity;
    /**
     * 签收数量
     */
    private Integer signedQuantity;
    /**
     * 签收总价，单位：分
     */
    private Integer signedTotal;

    /**
     * 订单备注
     */
    @TableField(typeHandler = JacksonTypeHandler.class)
    private CustomerOrderRemark orderRemark;

}