package cn.iocoder.foodnexus.module.order.dal.dataobject.customerorder;

import cn.iocoder.foodnexus.module.erp.api.vo.warehouse.WarehouseInfo;
import cn.iocoder.foodnexus.module.order.dto.CustomerAddressInfo;
import cn.iocoder.foodnexus.module.order.dto.CustomerOrderRemark;
import cn.iocoder.foodnexus.module.order.enums.CustomerOrderStatus;
import cn.iocoder.foodnexus.module.order.enums.DeliveryMode;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import lombok.*;

import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;

/**
 * 客户总订单 DO
 *
 * @author 超级管理员
 */
@TableName(value = "order_customer_order", autoResultMap = true)
@KeySequence("order_customer_order_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CustomerOrderDO extends BaseDO {

    /**
     * id
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;
    /**
     * 订单编号
     */
    private String code;
    /**
     * 订单状态
     *
     * 枚举 {@link CustomerOrderStatus}
     */
    private CustomerOrderStatus orderStatus;
    /**
     * 客户id
     */
    private Long customerId;
    /**
     * 收获仓库id
     */
    private Long warehouseId;
    /**
     * 收获库区id
     */
    private Long warehouseAreaId;
    /**
     * 仓库信息
     */
    @TableField(typeHandler = JacksonTypeHandler.class)
    private WarehouseInfo warehouseInfo;
    /**
     * 客户收货地址id
     */
    private Long addressId;
    /**
     * 客户收货地址info
     */
    @TableField(typeHandler = JacksonTypeHandler.class)
    private CustomerAddressInfo addressInfo;
    /**
     * 配送模式
     *
     * 枚举 {@link DeliveryMode}
     */
    private DeliveryMode deliveryMode;
    /**
     * 采购订单数
     */
    private Integer productCount;
    /**
     * 供应商数
     */
    private Integer supplierCount;
    /**
     * 预计配送开始时间
     */
    private LocalDateTime planDeliveryStartTime;
    /**
     * 预计配送结束时间
     */
    private LocalDateTime planDeliveryEndTime;
    /**
     * 订单总金额(分)
     */
    private Integer orderAmount;
    /**
     * 实际支付总金额(分)
     */
    private Integer actualAmount;
    /**
     * 配送公司
     */
    private String operCompany;

    /**
     * 订单备注
     */
    @TableField(typeHandler = JacksonTypeHandler.class)
    private CustomerOrderRemark orderRemark;

}