package cn.iocoder.foodnexus.module.order.controller.admin.customerorderrecord.vo;

import cn.iocoder.foodnexus.module.order.enums.CustomerOrderStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import jakarta.validation.constraints.*;

@Schema(description = "管理后台 - 客户订单进度记录新增/修改 Request VO")
@Data
public class CustomerOrderRecordSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "19592")
    private Long id;

    @Schema(description = "客户订单id", requiredMode = Schema.RequiredMode.REQUIRED, example = "14294")
    @NotNull(message = "客户订单id不能为空")
    private Long customerOrderId;

    @Schema(description = "订单状态", requiredMode = Schema.RequiredMode.REQUIRED, example = "1")
    @NotEmpty(message = "订单状态不能为空")
    private CustomerOrderStatus orderStatus;

    @Schema(description = "客户id", requiredMode = Schema.RequiredMode.REQUIRED, example = "28995")
    @NotNull(message = "客户id不能为空")
    private Long customerId;

    @Schema(description = "供应商id", example = "8073")
    private Long supplierId;

    @Schema(description = "信息")
    private String messageInfo;

    @Schema(description = "扩展信息")
    private String extendInfo;

}