package cn.iocoder.foodnexus.module.order.controller.admin.customerorderrecord.vo;

import cn.iocoder.foodnexus.module.order.enums.CustomerOrderStatus;
import lombok.*;
import java.util.*;
import io.swagger.v3.oas.annotations.media.Schema;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;

import static cn.iocoder.foodnexus.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 客户订单进度记录分页 Request VO")
@Data
public class CustomerOrderRecordPageReqVO extends PageParam {

    @Schema(description = "客户订单id", example = "14294")
    private Long customerOrderId;

    @Schema(description = "订单状态", example = "1")
    private CustomerOrderStatus orderStatus;

    @Schema(description = "客户id", example = "28995")
    private Long customerId;

    @Schema(description = "供应商id", example = "8073")
    private Long supplierId;

    @Schema(description = "信息")
    private String messageInfo;

    @Schema(description = "扩展信息")
    private String extendInfo;

    @Schema(description = "创建者")
    private String creator;

    @Schema(description = "创建时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime[] createTime;

}