package cn.iocoder.foodnexus.module.order.dto;

import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.util.List;

/**
 * @author : yanghao
 * create at:  2025/9/28  17:35
 * @description: 配送订单 - 实际配送信息
 */
@Data
public class DeliveryOrderUpdateReqVO {

    /**
     * 销售出库单id
     */
    @NotNull(message = "销售出库单id不能为空")
    private Long saleOutId;

    /**
     * 销售出库子项
     */
    @NotNull(message = "销售出库子项不能为空")
    @Valid
    private List<Item> items;

    @Data
    public static class Item {

        /**
         * 销售出库子id
         */
        @NotNull(message = "销售出库子id不能为空")
        private Long saleOutItemid;

        /**
         * 实际签收数量
         */
        @NotNull(message = "实际签收数量不能为空")
        @Min(value = 0, message = "实际签收数量最小为0")
        private Integer signedQuantity;

        /**
         * 说明
         */
        private String remark;

        /**
         * 相关文件
         */
        private List<String> remarkFiles;

    }
}
