package cn.iocoder.foodnexus.module.operations.dal.dataobject.inquiresupplierpush;

import lombok.*;
import java.util.*;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;

/**
 * 询价推送 DO
 *
 * @author 超级管理员
 */
@TableName("oper_inquire_supplier_push")
@KeySequence("oper_inquire_supplier_push_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class InquireSupplierPushDO extends BaseDO {

    /**
     * id
     */
    @TableId
    private Long id;
    /**
     * 供应商id
     */
    private Long supplierId;
    /**
     * 询价主题id
     */
    private Long inquirePriceId;
    /**
     * 询价子id
     */
    private Long inquirePriceItemId;
    /**
     * 商品id
     */
    private Long productId;
    /**
     * 商品分类id
     */
    private Long categoryId;
    /**
     * 供应商报价
     */
    private Integer supplierQuote;
    /**
     * 是否确认
     */
    private Boolean confirm;
    /**
     * 确认人员
     */
    private Long confirmUser;
    /**
     * 确认时间
     */
    private LocalDateTime confirmTime;


}