package cn.iocoder.foodnexus.module.operations.controller.admin.inquirecustomerpush.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import jakarta.validation.constraints.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;

@Schema(description = "管理后台 - 询价推送-客户新增/修改 Request VO")
@Data
public class InquireCustomerPushSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "25862")
    private Long id;

    @Schema(description = "客户id", requiredMode = Schema.RequiredMode.REQUIRED, example = "21995")
    @NotNull(message = "客户id不能为空")
    private Long customerId;

    @Schema(description = "询价主题id", requiredMode = Schema.RequiredMode.REQUIRED, example = "1397")
    @NotNull(message = "询价主题id不能为空")
    private Long inquirePriceId;

    @Schema(description = "是否确认", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotNull(message = "是否确认不能为空")
    private Boolean confirm;

    @Schema(description = "确认人员")
    private Long confirmUser;

    @Schema(description = "确认时间")
    private LocalDateTime confirmTime;

}