package cn.iocoder.foodnexus.module.system.service.province;

import java.util.*;
import jakarta.validation.*;
import cn.iocoder.foodnexus.module.system.controller.admin.province.vo.*;
import cn.iocoder.foodnexus.module.system.dal.dataobject.province.ProvinceDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;

/**
 * 地区数据 Service 接口
 *
 * @author 超级管理员
 */
public interface ProvinceService {

    /**
     * 创建地区数据
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createProvince(@Valid ProvinceSaveReqVO createReqVO);

    /**
     * 更新地区数据
     *
     * @param updateReqVO 更新信息
     */
    void updateProvince(@Valid ProvinceSaveReqVO updateReqVO);

    /**
     * 删除地区数据
     *
     * @param id 编号
     */
    void deleteProvince(Long id);

    /**
    * 批量删除地区数据
    *
    * @param ids 编号
    */
    void deleteProvinceListByIds(List<Long> ids);

    /**
     * 获得地区数据
     *
     * @param id 编号
     * @return 地区数据
     */
    ProvinceDO getProvince(Long id);

    /**
     * 获得地区数据分页
     *
     * @param pageReqVO 分页查询
     * @return 地区数据分页
     */
    PageResult<ProvinceDO> getProvincePage(ProvincePageReqVO pageReqVO);

    List<ProvinceDO> queryList(Long parentId, Integer type, String keyword);
}