package cn.iocoder.foodnexus.module.order.service.customerorderitem;

import java.util.*;

import cn.iocoder.foodnexus.module.order.controller.app.customerOrder.vo.AppCustomerOrderItemSaveReqVO;
import jakarta.validation.*;
import cn.iocoder.foodnexus.module.order.controller.admin.customerorderitem.vo.*;
import cn.iocoder.foodnexus.module.order.dal.dataobject.customerorderitem.CustomerOrderItemDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;

/**
 * 客户订单-子订单 Service 接口
 *
 * @author 超级管理员
 */
public interface CustomerOrderItemService {

    /**
     * 创建客户订单-子订单
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createCustomerOrderItem(@Valid CustomerOrderItemSaveReqVO createReqVO);

    /**
     * 更新客户订单-子订单
     *
     * @param updateReqVO 更新信息
     */
    void updateCustomerOrderItem(@Valid CustomerOrderItemSaveReqVO updateReqVO);

    /**
     * 删除客户订单-子订单
     *
     * @param id 编号
     */
    void deleteCustomerOrderItem(Long id);

    /**
    * 批量删除客户订单-子订单
    *
    * @param ids 编号
    */
    void deleteCustomerOrderItemListByIds(List<Long> ids);

    /**
     * 获得客户订单-子订单
     *
     * @param id 编号
     * @return 客户订单-子订单
     */
    CustomerOrderItemDO getCustomerOrderItem(Long id);

    /**
     * 获得客户订单-子订单分页
     *
     * @param pageReqVO 分页查询
     * @return 客户订单-子订单分页
     */
    PageResult<CustomerOrderItemDO> getCustomerOrderItemPage(CustomerOrderItemPageReqVO pageReqVO);

    void createBatch(List<CustomerOrderItemDO> orderItems, Long orderId);
}