package cn.iocoder.foodnexus.module.order.service.checktaskitems;

import java.util.*;

import cn.iocoder.foodnexus.module.order.controller.admin.checktask.vo.CheckTaskItemsPageReqVO;
import cn.iocoder.foodnexus.module.order.controller.admin.checktask.vo.CheckTaskItemsSaveReqVO;
import jakarta.validation.*;
import cn.iocoder.foodnexus.module.order.controller.admin.checktask.vo.*;
import cn.iocoder.foodnexus.module.order.dal.dataobject.checktaskitems.CheckTaskItemsDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;

/**
 * 来料质检清单 Service 接口
 *
 * @author 超级管理员
 */
public interface CheckTaskItemsService {

    /**
     * 创建来料质检清单
     *
     * @param createReqVO 创建信息
     * @return 编号
     */
    Long createCheckTaskItems(@Valid CheckTaskItemsSaveReqVO createReqVO);

    /**
     * 更新来料质检清单
     *
     * @param updateReqVO 更新信息
     */
    void updateCheckTaskItems(@Valid CheckTaskItemsSaveReqVO updateReqVO);

    /**
     * 删除来料质检清单
     *
     * @param id 编号
     */
    void deleteCheckTaskItems(Long id);

    /**
    * 批量删除来料质检清单
    *
    * @param ids 编号
    */
    void deleteCheckTaskItemsListByIds(List<Long> ids);

    /**
     * 获得来料质检清单
     *
     * @param id 编号
     * @return 来料质检清单
     */
    CheckTaskItemsDO getCheckTaskItems(Long id);

    /**
     * 获得来料质检清单分页
     *
     * @param pageReqVO 分页查询
     * @return 来料质检清单分页
     */
    PageResult<CheckTaskItemsDO> getCheckTaskItemsPage(CheckTaskItemsPageReqVO pageReqVO);

}