package cn.iocoder.foodnexus.module.order.controller.admin.customerorderitem.vo;

import cn.iocoder.foodnexus.module.order.dto.CustomerOrderRemark;
import cn.iocoder.foodnexus.module.product.api.dto.ProductInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;

import java.time.LocalDateTime;
import cn.idev.excel.annotation.*;

@Schema(description = "管理后台 - 客户订单-子订单 Response VO")
@Data
@ExcelIgnoreUnannotated
public class CustomerOrderItemRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "22980")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "客户订单id", requiredMode = Schema.RequiredMode.REQUIRED, example = "15521")
    @ExcelProperty("客户订单id")
    private Long orderId;

    @Schema(description = "客户id", requiredMode = Schema.RequiredMode.REQUIRED, example = "18288")
    @ExcelProperty("客户id")
    private Long customerId;

    @Schema(description = "商品id", requiredMode = Schema.RequiredMode.REQUIRED, example = "9665")
    @ExcelProperty("商品id")
    private Long productId;

    @Schema(description = "商品名称", example = "李四")
    @ExcelProperty("商品名称")
    private String productName;

    @Schema(description = "商品信息")
    @ExcelProperty("商品信息")
    private ProductInfo productInfo;

    @Schema(description = "商品对应供应商id", requiredMode = Schema.RequiredMode.REQUIRED, example = "19874")
    @ExcelProperty("商品对应供应商id")
    private Long supplierId;

    @Schema(description = "供应商名称", example = "芋艿")
    @ExcelProperty("供应商名称")
    private String supplierName;

    @Schema(description = "创建时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

    @Schema(description = "订单商品单价，单位：分", requiredMode = Schema.RequiredMode.REQUIRED, example = "29922")
    @ExcelProperty("订单商品单价，单位：分")
    private Integer orderItemPrice;

    @Schema(description = "订单商品总价，单位：分", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("订单商品总价，单位：分")
    private Integer orderItemTotal;

    @Schema(description = "订单商品数量", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("订单商品数量")
    private Integer orderItemQuantity;

    @Schema(description = "签收数量", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("签收数量")
    private Integer signedQuantity;

    @Schema(description = "签收总价，单位：分", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("签收总价，单位：分")
    private Integer signedTotal;

    @Schema(description = "订单备注")
    private CustomerOrderRemark orderRemark;

}