package cn.iocoder.foodnexus.module.order.controller.admin.checktask.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import cn.idev.excel.annotation.*;
import cn.iocoder.foodnexus.framework.excel.core.annotations.DictFormat;
import cn.iocoder.foodnexus.framework.excel.core.convert.DictConvert;

@Schema(description = "管理后台 - 来料质检 Response VO")
@Data
@ExcelIgnoreUnannotated
public class CheckTaskRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "4629")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "编号", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("编号")
    private String no;

    @Schema(description = "状态", requiredMode = Schema.RequiredMode.REQUIRED, example = "2")
    @ExcelProperty(value = "状态", converter = DictConvert.class)
    @DictFormat("order_check_task_status") // TODO 代码优化：建议设置到对应的 DictTypeConstants 枚举类中
    private String status;

    @Schema(description = "供应商编号", requiredMode = Schema.RequiredMode.REQUIRED, example = "10284")
    @ExcelProperty("供应商编号")
    private Long supplierId;

    @Schema(description = "关联采购订单id", requiredMode = Schema.RequiredMode.REQUIRED, example = "31869")
    @ExcelProperty("关联采购订单id")
    private Long purchaseOrderId;

    @Schema(description = "关联客户订单id", requiredMode = Schema.RequiredMode.REQUIRED, example = "1535")
    @ExcelProperty("关联客户订单id")
    private Long customerOrderId;

    @Schema(description = "客户id", requiredMode = Schema.RequiredMode.REQUIRED, example = "7050")
    @ExcelProperty("客户id")
    private Long customerId;

    @Schema(description = "到货时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("到货时间")
    private LocalDateTime arrivalTime;

    @Schema(description = "备注", example = "你猜")
    @ExcelProperty("备注")
    private String remark;

    @Schema(description = "附件")
    @ExcelProperty("附件")
    private String files;

    @Schema(description = "创建时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

}