package cn.iocoder.foodnexus.module.order.dto;

import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.Data;

import java.util.List;

/**
 * @author : yanghao
 * create at:  2025/9/30  10:02
 * @description: 客户订单 - 退货
 */
@Data
public class AppCustomerReturnOrderReqVO {

    /**
     * 客户订单ID
     */
    @NotNull(message = "订单id不能为空")
    private Long customerOrderId;


    /**
     * 说明
     */
    private String remark;

    /**
     * 相关文件
     */
    private List<String> remarkFiles;

    /**
     * 退货子项
     */
    @NotNull(message = "退货子项不能为空")
    @Size(min = 1, message = "退货子项不能为空")
    private List<Item> orderItems;


    @Data
    public static class Item {

        /**
         * 客户订单子项id
         */
        @NotNull(message = "客户订单子项不能为空")
        private Long customerOrderItemId;

        /**
         * 商品id
         */
        @NotNull(message = "商品不能为空")
        private Long productId;

        /**
         * 退货数量
         */
        @NotNull(message = "退货数量不能为空")
        private Integer returnCount;

        /**
         * 备注
         */
        private String remark;

    }

}
