package cn.iocoder.foodnexus.module.operations.controller.app.inquiresupplierpush;

import cn.iocoder.foodnexus.framework.common.pojo.CommonResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import cn.iocoder.foodnexus.framework.common.util.object.BeanUtils;
import cn.iocoder.foodnexus.framework.security.core.util.SecurityFrameworkUtils;
import cn.iocoder.foodnexus.module.erp.api.service.ErpSupplierApi;
import cn.iocoder.foodnexus.module.operations.controller.app.inquiresupplierpush.vo.AppInquireSupplierPushConfirmReqVO;
import cn.iocoder.foodnexus.module.operations.controller.app.inquiresupplierpush.vo.AppInquireSupplierPushDetailsRespVO;
import cn.iocoder.foodnexus.module.operations.controller.app.inquiresupplierpush.vo.AppInquireSupplierPushPageReqVO;
import cn.iocoder.foodnexus.module.operations.controller.app.inquiresupplierpush.vo.AppInquireSupplierPushRespVO;
import cn.iocoder.foodnexus.module.operations.service.inquirepriceitem.InquirePriceItemService;
import cn.iocoder.foodnexus.module.operations.service.inquiresupplierpush.InquireSupplierPushService;
import cn.iocoder.foodnexus.module.system.annotations.AppSystemAuth;
import cn.iocoder.foodnexus.framework.common.enums.UserSystemEnum;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import static cn.iocoder.foodnexus.framework.common.pojo.CommonResult.success;

@Tag(name = "APP - 询价推送")
@RestController
@RequestMapping("/operations/inquire-supplier-push")
@Validated
@AppSystemAuth(UserSystemEnum.SUPPLIER)
public class AppInquireSupplierPushController {

    @Resource
    private InquireSupplierPushService inquireSupplierPushService;

    @Autowired
    private InquirePriceItemService inquirePriceItemService;

    @Autowired
    private ErpSupplierApi supplierApi;

    @PostMapping("/confirm")
    @Operation(summary = "确认询价")
    public CommonResult<Boolean> updateInquireSupplierPush(@Valid @RequestBody AppInquireSupplierPushConfirmReqVO updateReqVO) {
        updateReqVO.setSupplierId(supplierApi.querySupplierIdByUserId(SecurityFrameworkUtils.getLoginUserId()));
        inquireSupplierPushService.confirm(updateReqVO);
        return success(true);
    }

    @GetMapping("/get")
    @Operation(summary = "获得询价推送")
    @Parameter(name = "id", description = "询价主题id", required = true, example = "1024")
    public CommonResult<AppInquireSupplierPushDetailsRespVO> getInquireSupplierPush(@RequestParam("id") Long id) {
        AppInquireSupplierPushPageReqVO pageReqVO = new AppInquireSupplierPushPageReqVO();
        pageReqVO.setInquirePriceId(id);
        pageReqVO.setSupplierId(supplierApi.querySupplierIdByUserId(SecurityFrameworkUtils.getLoginUserId()));
        PageResult<AppInquireSupplierPushRespVO> result = inquireSupplierPushService.getAppInquireSupplierPushPage(pageReqVO);
        if (CommonUtil.isNotEmpty(result) && CommonUtil.isNotEmpty(result.getList())) {
            AppInquireSupplierPushRespVO inquirePrice = result.getList().get(0);
            return success(BeanUtils.toBean(inquirePrice, AppInquireSupplierPushDetailsRespVO.class, item -> {
                item.setSupplierItems(inquirePriceItemService.queryListWithSupplierQuote(item.getId(), pageReqVO.getSupplierId()));
            }));
        }
        return success(new AppInquireSupplierPushDetailsRespVO());
    }

    @GetMapping("/page")
    @Operation(summary = "获得询价推送分页")
    public CommonResult<PageResult<AppInquireSupplierPushRespVO>> getInquireSupplierPushPage(@Valid AppInquireSupplierPushPageReqVO pageReqVO) {
        pageReqVO.setSupplierId(supplierApi.querySupplierIdByUserId(SecurityFrameworkUtils.getLoginUserId()));
        return success(inquireSupplierPushService.getAppInquireSupplierPushPage(pageReqVO));
    }

}