package cn.iocoder.foodnexus.module.order.controller.app.customerOrder.vo;

import cn.iocoder.foodnexus.framework.common.validation.InEnum;
import cn.iocoder.foodnexus.module.order.enums.DeliveryMode;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.List;

import static cn.iocoder.foodnexus.framework.common.util.date.DateUtils.FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND;

@Schema(description = "管理后台 - 客户总订单新增/修改 Request VO")
@Data
public class AppCustomerOrderSaveReqVO {

    @Schema(description = "订单id,新增为空")
    private Long id;

    @Schema(description = "收获仓库id", hidden = true)
    private Long warehouseId;

    @Schema(description = "收获库区id", hidden = true)
    private Long warehouseAreaId;

    @Schema(description = "客户收货地址id")
    @NotNull(message = "客户收货地址id不能为空")
    private Long addressId;

    @Schema(description = "配送模式", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotNull(message = "配送模式不能为空")
    private DeliveryMode deliveryMode;

    @Schema(description = "预计配送开始时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime planDeliveryStartTime;

    @Schema(description = "预计配送结束时间")
    @DateTimeFormat(pattern = FORMAT_YEAR_MONTH_DAY_HOUR_MINUTE_SECOND)
    private LocalDateTime planDeliveryEndTime;

    @Schema(description = "配送公司")
    private String operCompany;

    @Schema(description = "orderItems")
    @Valid
    @NotNull(message = "订单子项不能为空")
    @Size(min = 1, message = "订单子项不能为空")
    private List<AppCustomerOrderItemSaveReqVO> orderItems;

}