package cn.iocoder.foodnexus.module.order.api;

import cn.iocoder.foodnexus.module.order.dto.CustomerOrderDTO;
import cn.iocoder.foodnexus.module.order.dto.CustomerOrderItemDTO;
import cn.iocoder.foodnexus.module.order.enums.CustomerOrderStatus;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author : yanghao
 * create at:  2025/9/22  15:31
 * @description: 客户订单
 */
public interface CustomerOrderApi {

    CustomerOrderDTO queryById(Long customerOrderId);

    List<CustomerOrderItemDTO> queryItemsByOrderId(Long customerOrderId);

    void updateOrderStatus(Long customerOrderId, CustomerOrderStatus updateOrderStatus);

    Map<Long, CustomerOrderDTO> getOrderMap(Collection<Long> orderIds);

    List<CustomerOrderItemDTO> queryItemsByIds(Collection<Long> orderItems);

    void updateItems(List<CustomerOrderItemDTO> updateItems);

    Map<Long, String> getCodeMap(Collection<Long> longs);
}
