package cn.iocoder.foodnexus.module.operations.controller.admin.inquireprice.vo;

import cn.iocoder.foodnexus.module.operations.controller.admin.inquirepriceitem.vo.InquirePriceItemRespVO;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;
import cn.idev.excel.annotation.*;

@Schema(description = "管理后台 - 询价管理 Response VO")
@Data
@ExcelIgnoreUnannotated
public class InquirePriceRespVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "16631")
    @ExcelProperty("id")
    private Long id;

    @Schema(description = "询价主题", requiredMode = Schema.RequiredMode.REQUIRED, example = "李四")
    @ExcelProperty("询价主题")
    private String inquiryName;

    @Schema(description = "询价年月")
    @ExcelProperty("询价年月")
    private String inquiryYearMonth;

    @Schema(description = "客户id", requiredMode = Schema.RequiredMode.REQUIRED, example = "6248")
    @ExcelProperty("客户id")
    private Long customerId;

    @Schema(description = "客户名称", example = "李四")
    @ExcelProperty("客户名称")
    private String customerName;

    @Schema(description = "是否推送", requiredMode = Schema.RequiredMode.REQUIRED)
    @ExcelProperty("是否推送")
    private Boolean isPush;

    @Schema(description = "推送客户明细")
    @ExcelProperty("推送客户明细")
    private String pushCustomerInfo;

    @Schema(description = "创建时间")
    @ExcelProperty("创建时间")
    private LocalDateTime createTime;

    @Schema(description = "创建人")
    @ExcelProperty("创建人")
    private String creator;

    @Schema(description = "items")
    private List<InquirePriceItemRespVO> items;

}