package cn.iocoder.foodnexus.module.erp.dal.dataobject.purchase;

import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;
import cn.iocoder.foodnexus.module.erp.api.enums.ErpAuditStatus;
import cn.iocoder.foodnexus.module.erp.enums.SaleOrderPickUpStatus;
import cn.iocoder.foodnexus.module.erp.api.vo.warehouse.WarehouseInfo;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.finance.ErpAccountDO;
import cn.iocoder.foodnexus.module.order.dto.CustomerAddressInfo;
import com.baomidou.mybatisplus.annotation.KeySequence;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.JacksonTypeHandler;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * ERP 采购退货 DO
 *
 * @author 芋道源码
 */
@TableName(value = "erp_purchase_return", autoResultMap = true)
@KeySequence("erp_purchase_return_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ErpPurchaseReturnDO extends BaseDO {

    /**
     * 编号
     */
    @TableId
    private Long id;
    /**
     * 采购退货单号
     */
    private String no;
    /**
     * 退货状态
     *
     * 枚举 {@link ErpAuditStatus}
     */
    private Integer status;
    /**
     * 供应商编号
     *
     * 关联 {@link ErpSupplierDO#getId()}
     */
    private Long supplierId;
    /**
     * 结算账户编号
     *
     * 关联 {@link ErpAccountDO#getId()}
     */
    private Long accountId;
    /**
     * 退货时间
     */
    private LocalDateTime returnTime;

    /**
     * 采购订单编号
     *
     * 关联 {@link ErpPurchaseOrderDO#getId()}
     */
    private Long orderId;
    /**
     * 采购订单号
     *
     * 冗余 {@link ErpPurchaseOrderDO#getNo()}
     */
    private String orderNo;

    /**
     * 合计数量
     */
    private BigDecimal totalCount;
    /**
     * 最终合计价格，单位：分
     *
     * totalPrice = totalProductPrice + totalTaxPrice - discountPrice + otherPrice
     */
    private BigDecimal totalPrice;
    /**
     * 已退款金额，单位：分
     *
     * 目的：和 {@link cn.iocoder.foodnexus.module.erp.dal.dataobject.finance.ErpFinancePaymentDO} 结合，记录已支付金额
     */
    private BigDecimal refundPrice;

    /**
     * 合计产品价格，单位：分
     */
    private BigDecimal totalProductPrice;
    /**
     * 合计税额，单位：分
     */
    private BigDecimal totalTaxPrice;
    /**
     * 优惠率，百分比
     */
    private BigDecimal discountPercent;
    /**
     * 优惠金额，单位：分
     *
     * discountPrice = (totalProductPrice + totalTaxPrice) * discountPercent
     */
    private BigDecimal discountPrice;
    /**
     * 其它金额，单位：分
     */
    private BigDecimal otherPrice;

    /**
     * 附件地址
     */
    @TableField(typeHandler = JacksonTypeHandler.class)
    private List<String> filesUrl;
    /**
     * 备注
     */
    private String remark;

    /**
     * 退货状态
     * 枚举 {@link SaleOrderPickUpStatus}
     */
    private String returnsStatus;

    /**
     * 客户收货地址id
     */
    private Long addressId;

    /**
     * 客户收货地址info
     */
    @TableField(typeHandler = JacksonTypeHandler.class)
    private CustomerAddressInfo addressInfo;

    /**
     * 收获仓库id
     */
    private Long warehouseId;
    /**
     * 收获库区id
     */
    private Long warehouseAreaId;

    /**
     * 仓库信息
     */
    @TableField(typeHandler = JacksonTypeHandler.class)
    private WarehouseInfo warehouseInfo;

    /**
     * 配送人员
     *
     * DeliveryStaffDO
     */
    private Long deliveryStaffId;

    /**
     * 客户订单id
     *
     * 关联 {@link // CustomerOrderDO#getId()}
     */
    private Long customerOrderId;

    /**
     * 销售订单id
     */
    private Long saleOrderId;

    /**
     * 客户id
     */
    private Long customerId;

}