package cn.iocoder.foodnexus.module.erp.controller.admin.stock.vo.warehouse;

import cn.idev.excel.annotation.ExcelProperty;
import cn.iocoder.foodnexus.framework.common.enums.CommonStatusEnum;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import cn.iocoder.foodnexus.framework.common.validation.InEnum;
import cn.iocoder.foodnexus.framework.excel.core.annotations.DictFormat;
import cn.iocoder.foodnexus.framework.excel.core.convert.DictConvert;
import cn.iocoder.foodnexus.module.erp.api.enums.WarehouseLevelEnum;
import cn.iocoder.foodnexus.module.system.enums.DictTypeConstants;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@Schema(description = "管理后台 - ERP 仓库分页 Request VO")
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ErpWarehousePageReqVO extends PageParam {

    @Schema(description = "仓库名称", example = "李四")
    private String name;

    @Schema(description = "开启状态", example = "1")
    @InEnum(CommonStatusEnum.class)
    private Integer status;

    @Schema(description = "联系电话", example = "18818288888")
    private String telephone;

    @Schema(description = "仓库等级")
    @InEnum(WarehouseLevelEnum.class)
    private String level;

    @Schema(description = "库区所属仓库id")
    private Long parentId;


}