package cn.iocoder.foodnexus.module.erp.api.vo.supplier;

import cn.iocoder.foodnexus.framework.common.enums.CommonStatusEnum;
import cn.iocoder.foodnexus.framework.common.validation.InEnum;
import cn.iocoder.foodnexus.framework.common.validation.Mobile;
import cn.iocoder.foodnexus.framework.common.validation.Telephone;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author : yanghao
 * create at:  2025/9/1  17:04
 * @description: 部门 - 供应商添加
 */
@Data
public class SupplierAddReqVO {

    /**
     * 供应商名称
     */
    @NotEmpty(message = "供应商名称不能为空")
    private String name;

    /**
     * 联系人
     */
    private String contact;

    /**
     * 手机号码
     */
    @Mobile
    private String mobile;

    /**
     * 联系电话
     */
    @Telephone
    private String telephone;

    /**
     * 电子邮箱
     */
    @Email
    private String email;

    /**
     * 传真
     */
    private String fax;

    /**
     * 备注
     */
    private String remark;

    /**
     * 开启状态
     */
    @NotNull(message = "开启状态不能为空")
    @InEnum(value = CommonStatusEnum.class)
    private Integer status;

    /**
     * 排序
     */
    @NotNull(message = "排序不能为空")
    private Integer sort;

    /**
     * 纳税人识别号
     */
    private String taxNo;

    /**
     * 税率
     */
    private BigDecimal taxPercent;

    /**
     * 开户行
     */
    private String bankName;

    /**
     * 开户账号
     */
    private String bankAccount;

    /**
     * 开户地址
     */
    private String bankAddress;

    /**
     * 统一社会信用代码
     */
    private String unifiedSocialCreditCode;

    /**
     * 法人姓名
     */
    private String legalPerson;

    /**
     * 注册地址
     */
    private String registeredAddress;

    /**
     * 成立时间
     */
    private LocalDateTime establishmentTime;

    /**
     * 企业类型
     */
    private String enterpriseType;

    /**
     * 是否包括港澳台及外商投资等企业
     */
    private String isForeignRelated;
    /**
     * 经营商品类型
     */
    private String businessGoodsType;

    /**
     * 主要经营商品
     */
    private String mainBusinessGoods;

    /**
     * 保密资质或保密能力和条件描述
     */
    private String confidentialityQualification;

    /**
     * 副食品供应实践经验或与军队合作基础条件描述
     */
    private String nonStapleSupplyExperience;

    /**
     * 副食品筹措和保供能力描述
     */
    private String nonStapleSupplyCapacity;

    /**
     * 资质证明材料
     */
    private String files;

}
