CREATE TABLE `system_province` (
                                   `id` bigint(20) NOT NULL COMMENT 'id',
                                   `parent_id` bigint(20) NOT NULL DEFAULT '-1' COMMENT '父级id',
                                   `full_name` varchar(255) DEFAULT NULL COMMENT '名称',
                                   `quick_query` varchar(255) DEFAULT NULL COMMENT 'quickQuery',
                                   `type` tinyint(4) NOT NULL COMMENT '类型（1-省份 2-市 3-县 4-街道）',
                                   `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
                                   `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
                                   `creator` varchar(64) DEFAULT NULL COMMENT '创建人',
                                   `updater` varchar(64) DEFAULT NULL COMMENT '更新人',
                                   `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
                                   PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='地区数据';


CREATE TABLE `oper_delivery_staff` (
                                       `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键ID',
                                       `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '姓名',
                                       `id_number` varchar(18) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '身份证号',
                                       `contact` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '联系方式',
                                       `on_duty_status` varchar(24) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '在岗状态',
                                       `staff_year_birth` int(11) DEFAULT NULL COMMENT '人员出生年份',
                                       `health_status` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '健康状态',
                                       `driver_license_type` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '驾驶证类型',
                                       `license_start_time` datetime DEFAULT NULL COMMENT '驾驶证有效期开始时间',
                                       `license_end_time` datetime DEFAULT NULL COMMENT '驾驶证有效期结束时间',
                                       `driver_license_status` varchar(24) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '驾驶证状态',
                                       `health_certificate_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '健康证明文件路径',
                                       `driver_license_file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '机动车驾驶证图片路径',
                                       `remark` varchar(128) CHARACTER SET utf8mb4 DEFAULT NULL COMMENT '备注',
                                       `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
                                       `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
                                       `creator` varchar(64) CHARACTER SET utf8mb4 DEFAULT NULL COMMENT '创建人',
                                       `updater` varchar(64) CHARACTER SET utf8mb4 DEFAULT NULL COMMENT '更新人',
                                       `tenant_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '租户编号',
                                       `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
                                       PRIMARY KEY (`id`) USING BTREE,
                                       UNIQUE KEY `idx_id_number` (`id_number`) COMMENT '身份证号唯一约束'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='配送员信息表';

CREATE TABLE `oper_delivery_staff_customer` (
                                                `id` bigint(20) NOT NULL COMMENT 'id',
                                                `delivery_staff_id` bigint(20) NOT NULL COMMENT '配送员id',
                                                `customer_id` bigint(20) NOT NULL COMMENT '客户id',
                                                `creator` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '创建者',
                                                `create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
                                                `updater` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '' COMMENT '更新者',
                                                `update_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
                                                `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
                                                `tenant_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '租户编号',
                                                PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='配送员客户绑定表';

CREATE TABLE `oper_vehicle_info` (
                                     `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '序号，自增主键',
                                     `license_plate` varchar(20) NOT NULL COMMENT '车牌号',
                                     `vehicle_type` varchar(50) DEFAULT NULL COMMENT '车型',
                                     `load_weight` int(11) DEFAULT NULL COMMENT '载重 (kg)',
                                     `volume` decimal(10,2) DEFAULT NULL COMMENT '容积 (m³)',
                                     `vehicle_staff` bigint(20) DEFAULT NULL COMMENT '车辆绑定人员',
                                     `vehicle_staff_name` varchar(255) DEFAULT NULL COMMENT '车辆绑定人员名称',
                                     `staff_year_birth` int(11) DEFAULT NULL COMMENT '人员出生年份',
                                     `staff_phone` varchar(255) DEFAULT NULL COMMENT '人员联系方式',
                                     `staff_health_status` varchar(24) DEFAULT NULL COMMENT '人员健康状态',
                                     `staff_license_status` varchar(24) DEFAULT NULL COMMENT '人员驾驶证状态',
                                     `remark` varchar(128) DEFAULT NULL COMMENT '备注',
                                     `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
                                     `update_time` datetime DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT '更新时间',
                                     `creator` varchar(64) DEFAULT NULL COMMENT '创建人',
                                     `updater` varchar(64) DEFAULT NULL COMMENT '更新人',
                                     `tenant_id` bigint(20) NOT NULL DEFAULT '0' COMMENT '租户编号',
                                     `deleted` bit(1) NOT NULL DEFAULT b'0' COMMENT '是否删除',
                                     PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='车辆信息表';