package cn.iocoder.foodnexus.module.system.service.province;

import cn.hutool.core.collection.CollUtil;
import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import cn.iocoder.foodnexus.framework.mybatis.core.query.QueryWrapperX;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.stereotype.Service;
import jakarta.annotation.Resource;
import org.springframework.validation.annotation.Validated;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import cn.iocoder.foodnexus.module.system.controller.admin.province.vo.*;
import cn.iocoder.foodnexus.module.system.dal.dataobject.province.ProvinceDO;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageParam;
import cn.iocoder.foodnexus.framework.common.util.object.BeanUtils;

import cn.iocoder.foodnexus.module.system.dal.mysql.province.ProvinceMapper;

import static cn.iocoder.foodnexus.framework.common.exception.util.ServiceExceptionUtil.exception;
import static cn.iocoder.foodnexus.framework.common.util.collection.CollectionUtils.convertList;
import static cn.iocoder.foodnexus.framework.common.util.collection.CollectionUtils.diffList;
import static cn.iocoder.foodnexus.module.system.enums.ErrorCodeConstants.*;

/**
 * 地区数据 Service 实现类
 *
 * @author 超级管理员
 */
@Service
@Validated
public class ProvinceServiceImpl implements ProvinceService {

    @Resource
    private ProvinceMapper provinceMapper;

    @Override
    public Long createProvince(ProvinceSaveReqVO createReqVO) {
        // 插入
        ProvinceDO province = BeanUtils.toBean(createReqVO, ProvinceDO.class);
        provinceMapper.insert(province);

        // 返回
        return province.getId();
    }

    @Override
    public void updateProvince(ProvinceSaveReqVO updateReqVO) {
        // 校验存在
        validateProvinceExists(updateReqVO.getId());
        // 更新
        ProvinceDO updateObj = BeanUtils.toBean(updateReqVO, ProvinceDO.class);
        provinceMapper.updateById(updateObj);
    }

    @Override
    public void deleteProvince(Long id) {
        // 校验存在
        validateProvinceExists(id);
        // 删除
        provinceMapper.deleteById(id);
    }

    @Override
        public void deleteProvinceListByIds(List<Long> ids) {
        // 删除
        provinceMapper.deleteByIds(ids);
        }


    private void validateProvinceExists(Long id) {
        if (provinceMapper.selectById(id) == null) {
            throw exception("");
        }
    }

    @Override
    public ProvinceDO getProvince(Long id) {
        return provinceMapper.selectById(id);
    }

    @Override
    public PageResult<ProvinceDO> getProvincePage(ProvincePageReqVO pageReqVO) {
        return provinceMapper.selectPage(pageReqVO);
    }

    @Override
    public List<ProvinceDO> queryList(Long parentId, Integer type, String keyword) {
        return provinceMapper.selectList(Wrappers.<ProvinceDO>lambdaQuery()
                .eq(CommonUtil.isNotEmpty(parentId), ProvinceDO::getParentId, parentId)
                .eq(CommonUtil.isNotEmpty(type), ProvinceDO::getType, type)
                .and(CommonUtil.isNotBlank(keyword), query ->
                        query.like(ProvinceDO::getFullName, keyword).or().like(ProvinceDO::getQuickQuery, keyword))
                .orderByAsc(ProvinceDO::getId));
    }

}