package cn.iocoder.foodnexus.module.system.controller.app.province;

import cn.iocoder.foodnexus.framework.common.pojo.CommonResult;
import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import cn.iocoder.foodnexus.framework.common.util.object.BeanUtils;
import cn.iocoder.foodnexus.module.system.controller.admin.province.vo.ProvinceRespVO;
import cn.iocoder.foodnexus.module.system.controller.admin.province.vo.ProvinceSaveReqVO;
import cn.iocoder.foodnexus.module.system.service.province.ProvinceService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.validation.Valid;
import org.apache.commons.compress.utils.Lists;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

import static cn.iocoder.foodnexus.framework.common.pojo.CommonResult.success;

@Tag(name = "APP - 地区数据")
@RestController
@RequestMapping("/system/province")
@Validated
public class AppProvinceController {

    @Resource
    private ProvinceService provinceService;

    @GetMapping("/query")
    @Operation(summary = "获取省份信息")
    @Parameter(name = "parentId", description = "父级id")
    @Parameter(name = "type", description = "类型（1-省份 2-市 3-县区 4-街道）")
    @Parameter(name = "keyword", description = "查询字段")
    public CommonResult<List<ProvinceRespVO>> query(@RequestParam(value = "parentId", required = false) Long parentId,
                                                            @RequestParam(value = "type", required = false) Integer type,
                                                    @RequestParam(value = "keyword", required = false) String keyword) {
        if (CommonUtil.isEmpty(parentId) && CommonUtil.isEmpty(type) && CommonUtil.isEmpty(keyword)) {
            // 防止拉取所有数据
            return success(Lists.newArrayList());
        }
        return success(BeanUtils.toBean(provinceService.queryList(parentId, type, keyword), ProvinceRespVO.class));
    }
}