package cn.iocoder.foodnexus.module.product.api.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * @author : yanghao
 * create at:  2025/9/4  11:49
 * @description: 客户可见商品集合
 */
@Data
public class CustomerVisibleProductRespDTO implements Serializable {

    public CustomerVisibleProductRespDTO() {
        this.items = new ArrayList<>();
    }

    private List<CustomerProduct> items;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class CustomerProduct implements Serializable {

        /**
         * 供应商 - 报价
         */
        private Long inquireSupplierId;

        /**
         * 商品id
         */
        private Long productId;

        /**
         * 供应商报价
         */
        private Integer supplierQuote;

        /**
         * 市场价，单位使用：分
         */
        private Integer marketPrice;
        /**
         * 下浮率(%)
         */
        private BigDecimal floatingRate;

    }

    public void put(Long inquireSupplierId, Long productId, Integer supplierQuote, Integer marketPrice, BigDecimal floatingRate) {
        this.items.add(new CustomerProduct(inquireSupplierId, productId, supplierQuote, marketPrice, floatingRate));
    }

}
