package cn.iocoder.foodnexus.module.order.dal.mysql.checktask;

import java.util.*;

import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.framework.common.util.CommonUtil;
import cn.iocoder.foodnexus.framework.mybatis.core.query.LambdaQueryWrapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.mapper.BaseMapperX;
import cn.iocoder.foodnexus.framework.mybatis.core.query.MPJLambdaWrapperX;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.purchase.ErpPurchaseOrderDO;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.purchase.ErpSupplierDO;
import cn.iocoder.foodnexus.module.erp.dal.dataobject.sale.ErpCustomerDO;
import cn.iocoder.foodnexus.module.order.dal.dataobject.checktask.CheckTaskDO;
import cn.iocoder.foodnexus.module.order.dal.dataobject.checktaskitems.CheckTaskItemsDO;
import org.apache.ibatis.annotations.Mapper;
import cn.iocoder.foodnexus.module.order.controller.admin.checktask.vo.*;

/**
 * 来料质检 Mapper
 *
 * @author 超级管理员
 */
@Mapper
public interface CheckTaskMapper extends BaseMapperX<CheckTaskDO> {

    default PageResult<CheckTaskDO> selectPage(CheckTaskPageReqVO reqVO) {
        MPJLambdaWrapperX<CheckTaskDO> wrapper = new MPJLambdaWrapperX<CheckTaskDO>()
                .eqIfPresent(CheckTaskDO::getNo, reqVO.getNo())
                .eqIfPresent(CheckTaskDO::getStatus, reqVO.getStatus())
                .eqIfPresent(CheckTaskDO::getSupplierId, reqVO.getSupplierId())
                .eqIfPresent(CheckTaskDO::getPurchaseOrderId, reqVO.getPurchaseOrderId())
                .eqIfPresent(CheckTaskDO::getCustomerOrderId, reqVO.getCustomerOrderId())
                .eqIfPresent(CheckTaskDO::getCustomerId, reqVO.getCustomerId())
                .betweenIfPresent(CheckTaskDO::getArrivalTime, reqVO.getArrivalTime())
                .eqIfPresent(CheckTaskDO::getRemark, reqVO.getRemark())
                .eqIfPresent(CheckTaskDO::getFiles, reqVO.getFiles())
                .betweenIfPresent(CheckTaskDO::getCreateTime, reqVO.getCreateTime())
                .orderByDesc(CheckTaskDO::getId);
        if (CommonUtil.isNotBlank(reqVO.getProductName())) {
            wrapper.leftJoin(CheckTaskItemsDO.class, CheckTaskItemsDO::getCheckTaskId, CheckTaskDO::getId);
            wrapper.like(CheckTaskItemsDO::getProductName, reqVO.getProductName());
            wrapper.groupBy(CheckTaskDO::getId);
        }
        if (CommonUtil.isNotBlank(reqVO.getSupplierName())) {
            wrapper.leftJoin(ErpSupplierDO.class, ErpSupplierDO::getId, CheckTaskDO::getSupplierId);
            wrapper.like(ErpSupplierDO::getName, reqVO.getSupplierName());
            wrapper.groupBy(CheckTaskDO::getId);
        }
        if (CommonUtil.isNotBlank(reqVO.getCustomerName())) {
            wrapper.leftJoin(ErpCustomerDO.class, ErpCustomerDO::getId, CheckTaskDO::getCustomerId);
            wrapper.like(ErpCustomerDO::getName, reqVO.getCustomerName());
            wrapper.groupBy(CheckTaskDO::getId);
        }
        if (CommonUtil.isNotBlank(reqVO.getPurchaseOrderNo())) {
            wrapper.leftJoin(ErpPurchaseOrderDO.class, ErpPurchaseOrderDO::getId, CheckTaskDO::getPurchaseOrderId);
            wrapper.like(ErpPurchaseOrderDO::getNo, reqVO.getPurchaseOrderNo());
            wrapper.groupBy(CheckTaskDO::getId);
        }
        return selectPage(reqVO, wrapper);
    }

}