package cn.iocoder.foodnexus.module.order.controller.app.customerOrder.vo;

import cn.iocoder.foodnexus.module.order.dto.CustomerOrderRemark;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import lombok.Data;

import java.util.List;

/**
 * @author : yanghao
 * create at:  2025/10/10  15:20
 * @description: 客户订单评价
 */
@Data
public class AppCustomerOrderScoreReqVO {

    @Schema(description = "客户订单id")
    @NotNull(message = "客户订单id不能为空")
    private Long orderId;

    @Schema(description = "订单备注")
    private CustomerOrderRemark orderRemark;

    @Schema(description = "评价指标项")
    @Valid
    private List<Item> items;

    @Data
    public static class Item {

        @Schema(description = "评价指标id")
        @NotNull(message = "评价指标id不能为空")
        private Long scoreId;

        @Schema(description = "得分")
        @Min(value = 1, message = "得分最低1分")
        @Max(value = 5, message = "得分最高5分")
        private Integer score;

    }

}
