package cn.iocoder.foodnexus.module.order.controller.app.customerOrder;

import cn.iocoder.foodnexus.framework.common.enums.UserSystemEnum;
import cn.iocoder.foodnexus.framework.common.pojo.CommonResult;
import cn.iocoder.foodnexus.framework.common.pojo.PageResult;
import cn.iocoder.foodnexus.module.order.controller.app.customerOrder.vo.AppCustomerMonthOrderRespVO;
import cn.iocoder.foodnexus.module.order.controller.app.customerOrder.vo.AppCustomerMonthOrderTotalRespVO;
import cn.iocoder.foodnexus.module.order.controller.app.customerOrder.vo.AppCustomerOrderReconciliationReqVO;
import cn.iocoder.foodnexus.module.order.controller.app.customerOrder.vo.AppCustomerYearOrderPageReqVO;
import cn.iocoder.foodnexus.module.order.service.customerorder.CustomerOrderService;
import cn.iocoder.foodnexus.module.system.annotations.AppSystemAuth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import static cn.iocoder.foodnexus.framework.common.pojo.CommonResult.success;

/**
 * @author : yanghao
 * create at:  2025/10/13  14:13
 * @description: APP - 订单对账
 */
@Tag(name = "APP - 对账")
@RestController
@RequestMapping("/order/reconciliation")
@Validated
@AppSystemAuth(UserSystemEnum.CUSTOMER)
public class AppCustomerOrderReconciliationController {

    @Autowired
    private CustomerOrderService customerOrderService;

    @GetMapping("/page-year")
    @Operation(summary = "分页获取月度账单(按年份)")
    public CommonResult<AppCustomerMonthOrderRespVO> pageYear(@Valid AppCustomerYearOrderPageReqVO reqVO) {
        return success(customerOrderService.reconciliationPageYear(reqVO));
    }

    @GetMapping("/month-total")
    @Operation(summary = "分页获取客户订单(按月份)")
    @Parameter(name = "yearMonth", description = "年月(yyyy-MM)", required = true)
    public CommonResult<AppCustomerMonthOrderTotalRespVO> monthTotal(@RequestParam("yearMonth") String yearMonth) {
        return success(customerOrderService.monthTotal(yearMonth));
    }

    @PostMapping("/confirm")
    @Operation(summary = "确认账单")
    public CommonResult<Boolean> confirm(@Valid AppCustomerOrderReconciliationReqVO reqVO) {
        customerOrderService.reconciliationConfirm(reqVO);
        return success(Boolean.TRUE);
    }

}
