package cn.iocoder.foodnexus.module.order.controller.admin.checktask.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.*;
import java.util.*;
import jakarta.validation.constraints.*;
import org.springframework.format.annotation.DateTimeFormat;
import java.time.LocalDateTime;

@Schema(description = "管理后台 - 来料质检新增/修改 Request VO")
@Data
public class CheckTaskSaveReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "4629")
    private Long id;

    @Schema(description = "编号", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotEmpty(message = "编号不能为空")
    private String no;

    @Schema(description = "状态", requiredMode = Schema.RequiredMode.REQUIRED, example = "2")
    @NotNull(message = "状态不能为空")
    private String status;

    @Schema(description = "供应商编号", requiredMode = Schema.RequiredMode.REQUIRED, example = "10284")
    @NotNull(message = "供应商编号不能为空")
    private Long supplierId;

    @Schema(description = "关联采购订单id", requiredMode = Schema.RequiredMode.REQUIRED, example = "31869")
    @NotNull(message = "关联采购订单id不能为空")
    private Long purchaseOrderId;

    @Schema(description = "关联客户订单id", requiredMode = Schema.RequiredMode.REQUIRED, example = "1535")
    @NotNull(message = "关联客户订单id不能为空")
    private Long customerOrderId;

    @Schema(description = "客户id", requiredMode = Schema.RequiredMode.REQUIRED, example = "7050")
    @NotNull(message = "客户id不能为空")
    private Long customerId;

    @Schema(description = "到货时间", requiredMode = Schema.RequiredMode.REQUIRED)
    @NotNull(message = "到货时间不能为空")
    private LocalDateTime arrivalTime;

    @Schema(description = "备注", example = "你猜")
    private String remark;

    @Schema(description = "附件")
    private String files;

    @Schema(description = "来料质检清单")
    private List<CheckTaskItemsSaveReqVO> items;

}