package cn.iocoder.foodnexus.module.order.controller.admin.checktask.vo;

import cn.iocoder.foodnexus.framework.common.validation.InEnum;
import cn.iocoder.foodnexus.framework.common.enums.CheckTaskStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import lombok.Data;

import java.util.List;

/**
 * @author : yanghao
 * create at:  2025/9/24  17:31
 * @description: 质检来料质检
 */
@Data
public class CheckTaskCheckReqVO {

    @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "4629")
    @NotNull(message = "id不能为空")
    private Long id;

    @Schema(description = "状态", requiredMode = Schema.RequiredMode.REQUIRED, example = "2")
    @NotNull(message = "状态不能为空")
    @InEnum(CheckTaskStatus.class)
    private String status;

    @Schema(description = "备注", example = "你猜")
    private String remark;

    @Schema(description = "附件")
    private String files;

    @Schema(description = "质检清单")
    @Valid
    @NotNull(message = "质检清单不能为空")
    @Size(min = 1, message = "质检清单不能为空")
    private List<CheckItems> items;

    @Schema(description = "供应商评价")
    @Valid
    private CheckTaskSupplierScoreReqVO score;

    @Data
    public static class CheckItems {

        @Schema(description = "id", requiredMode = Schema.RequiredMode.REQUIRED, example = "5717")
        @NotNull(message = "items.id不能为空")
        private Long id;

        @Schema(description = "质检结果", requiredMode = Schema.RequiredMode.REQUIRED)
        @NotEmpty(message = "质检结果不能为空")
        private String checkResult;

    }

}
